; *************************************************************************************************
; * sega rom template 1.4
; *************************************************************************************************
; do not modify the start and end labels
; your code will be reconstructed when compiled in the correct place

#include	sega\s_main.mdl
#include	sega\s_math.mdl
#include	sega\s_input.mdl
#include	sega\s_dma.mdl
#include	sega\s_collision.mdl
#include	sega\s_saveram.mdl
#include	sega\s_z80.mdl

#segaromwavstart	458752	;wav files start originating
#memstart	16711680	;$ff0000

	org	512
segaromstart

	init_sega()	;get past sega security and clear ram
	init_segavdp()	;setup graphics and irq6 enabled also
	init_z80()		;setup dac


	init_collision()	;setup sqrt

	createsinetable(#sinetable)
; setup 4 palettes red,green,blue   0-63 and color 0-7

	sega_palette(#1,#0,#0,#0)	;black 0,0,0
	sega_palette(#2,#2,#2,#2)	;grey	72,72,72 text color on 2
	sega_palette(#3,#4,#4,#4)	;grey	72,72,72 text color on 2
	sega_palette(#4,#7,#7,#7)	;white 255,255,255
	sega_palette(#5,#0,#3,#0)	;dgreen 0,109,0
	sega_palette(#6,#0,#7,#0)	;green 0,255,0
	sega_palette(#7,#0,#7,#7)	;cyan 0,200,200
	sega_palette(#8,#0,#0,#3)	;lblue 0,0,109
	sega_palette(#9,#0,#0,#7)	;blue 0,0,255
	sega_palette(#10,#3,#0,#5)	;purple 109,0,182
	sega_palette(#11,#6,#0,#3)	;pink 218,0,109
	sega_palette(#12,#7,#0,#0)	;red 255,0,0
	sega_palette(#13,#7,#3,#0)	;orange 255,109,0
	sega_palette(#14,#7,#5,#0)	;peach 255,182,0
	sega_palette(#15,#7,#6,#0)	;peachl 255,218,0


	sega_palette(#17,#0,#0,#0)	;black 0,0,0
	sega_palette(#18,#2,#2,#2)	;grey	72,72,72 text color on 2
	sega_palette(#19,#4,#4,#4)	;grey	72,72,72 text color on 2
	sega_palette(#20,#7,#7,#7)	;white 255,255,255
	sega_palette(#21,#0,#3,#0)	;dgreen 0,109,0
	sega_palette(#22,#0,#7,#0)	;green 0,255,0
	sega_palette(#23,#0,#7,#7)	;cyan 0,200,200
	sega_palette(#24,#0,#0,#3)	;lblue 0,0,109
	sega_palette(#25,#0,#0,#7)	;blue 0,0,255
	sega_palette(#26,#3,#0,#5)	;purple 109,0,182
	sega_palette(#27,#6,#0,#3)	;pink 218,0,109
	sega_palette(#28,#7,#0,#0)	;red 255,0,0
	sega_palette(#29,#7,#3,#0)	;orange 255,109,0
	sega_palette(#30,#7,#5,#0)	;peach 255,182,0
	sega_palette(#31,#7,#6,#0)	;peachl 255,218,0




	sega_palette(#33,#0,#0,#0)	;black 0,0,0
	sega_palette(#34,#1,#1,#1)	;
	sega_palette(#35,#2,#2,#2)	;
	sega_palette(#36,#3,#3,#3)	;
	sega_palette(#37,#4,#4,#4)	;
	sega_palette(#38,#5,#5,#5)	;
	sega_palette(#39,#6,#6,#6)	;
	sega_palette(#40,#7,#7,#7)	;
	sega_palette(#41,#1,#1,#0)	;skin
	sega_palette(#42,#2,#1,#0)	;
	sega_palette(#43,#3,#2,#1)	;
	sega_palette(#44,#4,#3,#2)	;
	sega_palette(#45,#5,#4,#3)	;
	sega_palette(#46,#6,#5,#4)	;
	sega_palette(#47,#7,#6,#5)	;

	sega_palette(#49,#1,#1,#1)	;black
	sega_palette(#50,#3,#3,#3)	;grey
	sega_palette(#51,#7,#7,#7)	;white
	sega_palette(#52,#3,#0,#0)	;red
	sega_palette(#53,#5,#0,#0)	;red
	sega_palette(#54,#7,#0,#0)	;red
	sega_palette(#55,#0,#3,#0)	;green
	sega_palette(#56,#0,#5,#0)	;green
	sega_palette(#57,#0,#7,#0)	;green
	sega_palette(#58,#0,#0,#3)	;blue
	sega_palette(#59,#0,#0,#5)	;blue
	sega_palette(#60,#0,#0,#7)	;blue
	sega_palette(#61,#5,#4,#3)	;skin 150,125,100  5,4,3
	sega_palette(#62,#6,#5,#4)	;skin 200,175,150  6,5,4
	sega_palette(#63,#7,#6,#5)	;skin 250,225,200    7,6,5






	sega_font()	;setup diagnostic ascii (tiles 0-95) uses color #2 index

	sega_loadtile(#200,#16,#sphere)
	sega_loadtile(#216,#16,#triangle1)


	sega_background(#0,#61)	;change background color

	sega_clearplanea(#0)
	sega_clearplaneb(#0)




	move.w	#200,spritex1
	move.w	#200,spritey1
	sega_setsprite(#1,#200,spritex1,spritey1,#3,#3,#0,#0,#1,#0)

	sega_setsprite(#2,#216,#280,#250,#3,#3,#0,#0,#1,#0)



	move.w	#250,spritex2
	move.w	#200,spritey2
	sega_setsprite(#0,#200,spritex2,spritey2,#3,#3,#0,#0,#1,#0)

	sega_linksprite(#0,#1)
	sega_linksprite(#1,#2)
	sega_linksprite(#2,#0)

	move.w	#1,mode	;sphere collision
doloop
	device_ports()



	inputplayer1()


	sega_printa(#0,#0,#message,#0,#0,#3,#0)

;save old values
	move.w	spritex2,d7
	move.w	d7,oldx2
	move.w	spritey2,d7
	move.w	d7,oldy2
;control

	if	x,#0=inputplayer1_data2
	move.w	#1,mode
	endif

	if	x,#1=inputplayer1_data2
	move.w	#2,mode
	endif

	if	x,#2=inputplayer1_data2
	move.w	#3,mode
	endif

	if	x,#6=inputplayer1_data2
	move.w	#4,mode
	endif

; movements
;x
	if	x,#3=inputplayer1_data1
	move.w	spritex2,d7
	add.w	#1,d7
	move.w	d7,spritex2
	endif
	if	x,#2=inputplayer1_data1
	move.w	spritex2,d7
	sub.w	#1,d7
	move.w	d7,spritex2
	endif
;y

	if	x,#1=inputplayer1_data1
	move.w	spritey2,d7
	add.w	#1,d7
	move.w	d7,spritey2
	endif
	if	x,#0=inputplayer1_data1
	move.w	spritey2,d7
	sub.w	#1,d7
	move.w	d7,spritey2
	endif


	clr.l	d6
; sphere collision
	if	w,mode=#1
	sphere_collision(spritex1,spritey1,#16,spritex2,spritey2,#16)
	move.l	d7,d6
	sega_printa(#0,#1,#mode_sphere1,#0,#0,#3,#0)

; try smooth sliding collision

	if	w,d6>#0
	pointangle(spritex1,spritey1,spritex2,spritey2)
	move.b	d7,d5	;plot byte angle direction
	and.w	#255,d6
	plotangle(sinetable,spritex2,spritey2,d6,d6,d5)
	move.w	d6,spritex2
	move.w	d7,spritey2
	endif
	endif
; end sphere


; sphere collision
	if	w,mode=#2
	sphere_collision(spritex1,spritey1,#16,spritex2,spritey2,#16)
	move.l	d7,d6
	sega_printa(#0,#1,#mode_sphere2,#0,#0,#3,#0)
	endif
; end sphere





; box collision
	if	w,mode=#3
	box_collision(spritex2,spritey2,#16,spritex1,spritey1,#16)
	move.l	d7,d6
	sega_printa(#0,#1,#mode_box1,#0,#0,#3,#0)
	endif
; end box

; box collision smooth
	if	w,mode=#4
	box_collisionx(spritex2,spritey2,#16,spritex1,spritey1,#16)
	move.w	d7,spritex2
	box_collisiony(spritex2,spritey2,#16,spritex1,spritey1,#16)
	move.w	d7,spritey2
	sega_printa(#0,#1,#mode_box2,#0,#0,#3,#0)
	endif
; end box


	triangle_collision(#1,#280,#250,#32,spritex2,spritey2,#0)
	cmp.b	#0,d7
	bne	loadtri
	bra	skiptri

loadtri
	move.w	#1,d6
skiptri
	if	w,d6>#0
	sega_setsprite(#0,#200,spritex2,spritey2,#3,#3,#0,#0,#2,#0)
	else
	sega_setsprite(#0,#200,spritex2,spritey2,#3,#3,#0,#0,#1,#0)
	endif


	distance2d(spritex1,spritey1,spritex2,spritey2)
	move.w	d7,d6
	wordstring(d6,#word)
	sega_printa(#2,#3,#word,#0,#0,#0,#0)

	sync()
; code loop
	syncend()
	bra	doloop





def	word	string	16

def	sinetable	long
def	spritex1	word
def	spritey1	word
def	spritex2	word
def	spritey2	word

def	oldx2	word
def	oldy2	word

def	mode	word

message
	dc.b	'[A]=Ssphere [B]=sphere [C]=box [X]=Sbox  '
	dc.b	0,0
	even


mode_sphere1
	dc.b	'Smooth Sphere Collision        '
	dc.b	0,0
	even

mode_sphere2
	dc.b	'Sphere Detection               '
	dc.b	0,0
	even

mode_box1
	dc.b	'Box Detection                 '
	dc.b	0,0
	even

mode_box2
	dc.b	'Smooth Box Collision              '
	dc.b	0,0
	even


; make sure all data structures are even.  odd will work on emulation but crash on real hardware




; ***********************************************************************************************
; * code handlers
; ***********************************************************************************************
ignore_handler
	rte	; return from exception

;*************************************************************************************************
;irq 6
;*************************************************************************************************
interrupt6
;push to stack
	movem.l	a0-a6/d0-d7,-(a7)
;process things such as system clock and music player


	systemclock()	;update system clock


;pull from stack
	movem.l	(a7)+,a0-a6/d0-d7
	rte	; return from exception



; included data goes here before compile automatically


segaromend







